#include <iostream>
#include <fstream>
#include <algorithm> //rūšiavimo, min, max funkcijoms
#include <numeric> //sumavimo funkcijai

using namespace std;

struct OlimpinisRezultatas{
    string sportininkoKodas;
    double rezultatas;
};

struct GeriausiasPasiekimas{
    string sportininkoKodas;
    double rezultatas;
    int data;
    string valstybe;
    double skirtumasNuoOlimpiniu;
};

/*Ši funkcija bus naudojama abiejų rezultatų grupių vidurkių skaičiavimui, todėl parametru perduosime
skaičių masyvą ir gražinsime vidurkio reikšmę tolimesniems skaičiavimams*/
double gautiRezultatuVidurki(double rezultatai[], int rezultatuKiekis, ofstream& failasRezultatai){
    double rezultatuVidurkis;

    rezultatuVidurkis = accumulate(rezultatai, rezultatai + rezultatuKiekis, 0.0) / rezultatuKiekis;

    failasRezultatai << "Vidutiniškai diskas skriejo " << rezultatuVidurkis << " m." << endl;

    return rezultatuVidurkis;
}

void gautiRezultatuVidurkiuMinMaxSkirtuma(double rezultatai[], int rezultatuKiekis, ofstream& failasRezultatai){
    double minRezultatas, maxRezultatas, minMaxSkirtumas;

    minRezultatas = *min_element(rezultatai, rezultatai + rezultatuKiekis);
    maxRezultatas = *max_element(rezultatai, rezultatai + rezultatuKiekis);
    minMaxSkirtumas = maxRezultatas - minRezultatas;

    failasRezultatai << "Skirtumas tarp didžiausio ir mažiausio rezultato " << minMaxSkirtumas << " m." << endl;
}

string gautiPavarde(string sportininkoKodas){
   return sportininkoKodas.substr(1);
}

int gautiMetus (int data){
    int metai = data / 10000;
    return metai;
}

//Palyginimo pagal datą funkcija, minimumo skaičiavimui
bool palygintiPagalData(GeriausiasPasiekimas a, GeriausiasPasiekimas b){
    return a.data < b.data;
}

void gautiSeniausiaGeriausiaRezultata(GeriausiasPasiekimas geriausiPasiekimai[], int rezultatuKiekis, ofstream& failasRezultatai){
    GeriausiasPasiekimas seniausiasPasiekimas;

    seniausiasPasiekimas = *min_element(geriausiPasiekimai, geriausiPasiekimai + rezultatuKiekis, palygintiPagalData);

    failasRezultatai
        << gautiPavarde(seniausiasPasiekimas.sportininkoKodas) << " "
        << seniausiasPasiekimas.rezultatas << " "
        << gautiMetus(seniausiasPasiekimas.data) << " "
        << seniausiasPasiekimas.valstybe << endl;
}

//Palyginimo pagal vieną struktūro elementą funkciją, rūšiavimui
bool palygintiPagalSkirtumaNuoOlimpiniu(GeriausiasPasiekimas a, GeriausiasPasiekimas b){
    return a.skirtumasNuoOlimpiniu < b.skirtumasNuoOlimpiniu;
}

void isrikiuotiPagalSkirtumaNuoOlimpiniu(GeriausiasPasiekimas geriausiPasiekimai[], OlimpinisRezultatas olimpiniuRezultatai[], int rezultatuKiekis, ofstream& failasRezultatai){
    GeriausiasPasiekimas isrusiuotiGeriausiPasiekimai[32];

    //Suskaičiuojam kiekvieno sportininko skirtumą
    for (int i = 0; i < rezultatuKiekis; i++){
       geriausiPasiekimai[i].skirtumasNuoOlimpiniu = geriausiPasiekimai[i].rezultatas - olimpiniuRezultatai[i].rezultatas;
       isrusiuotiGeriausiPasiekimai[i] = geriausiPasiekimai[i];
    }

    // surūšiuojam struktūrų masyvą pagal rezultatų skirtumą, nurodant rūšiavimo funkciją
    sort(isrusiuotiGeriausiPasiekimai, isrusiuotiGeriausiPasiekimai + rezultatuKiekis, palygintiPagalSkirtumaNuoOlimpiniu);

    //rezultatų įrašymas į failą
    for (int i = 0; i < rezultatuKiekis; i++){
        failasRezultatai 
            << gautiPavarde(isrusiuotiGeriausiPasiekimai[i].sportininkoKodas) << " " 
            << isrusiuotiGeriausiPasiekimai[i].skirtumasNuoOlimpiniu << " m" << endl;
    }
}

int main()
{
    int eiluciuKiekisFaile;
    double olimpiniuVidurkis, geriausiuPasiekimuVidurkis;

    //Masyvų dydžius nurodome pagal sąlygą - iš viso dalyvavusių sportininkų skaičių
    OlimpinisRezultatas olimpiniuRezultatai[32];
    GeriausiasPasiekimas geriausiPasiekimai[32];
    double rezultataiSkaiciavimams[32];

    //Į struktūrų masyvą nuskaitome Olimpinių žaidynių rezultatų failą
    fstream failasOlimpines("Olimpines.txt");
    failasOlimpines >> eiluciuKiekisFaile;
    for (int i = 0; i < eiluciuKiekisFaile; i++){
        failasOlimpines >> olimpiniuRezultatai[i].sportininkoKodas >> olimpiniuRezultatai[i].rezultatas;
    }
    failasOlimpines.close();

    //Į struktūrų masyvą nuskaitome geriausių karjeros rezultatų failas
    char tempSimbolis;
    fstream failasPasiekimai("Pasiekimai.csv");
    for (int i = 0; i < eiluciuKiekisFaile; i++){
        getline(failasPasiekimai, geriausiPasiekimai[i].sportininkoKodas, ';');
        failasPasiekimai >> geriausiPasiekimai[i].rezultatas >> tempSimbolis >> geriausiPasiekimai[i].data >> tempSimbolis >> geriausiPasiekimai[i].valstybe >> ws;
    }
    failasPasiekimai.close();

    //Paruošiamas Rezultatų failas
    ofstream failasRezultatai("Rezultatai.txt");
    failasRezultatai << "Disko metimo duomenų analizės rezultatai:" << endl << endl << "Olimpinės žaidynės:" << endl;

    //Persikeliame olimpinių žaidynių rezultatus į skaičių masyvą, vidurkio skaičiavimui
    for (int i = 0; i <  eiluciuKiekisFaile; i++){
        rezultataiSkaiciavimams[i] = olimpiniuRezultatai[i].rezultatas;
    }

    //Paskaičiuojame ir įrašome į failą olimpinių žaidynių rezultatų vidurkį
    olimpiniuVidurkis = gautiRezultatuVidurki(rezultataiSkaiciavimams, eiluciuKiekisFaile, failasRezultatai);
    gautiRezultatuVidurkiuMinMaxSkirtuma(rezultataiSkaiciavimams, eiluciuKiekisFaile, failasRezultatai);

    failasRezultatai << endl << "Geriausi rezultatai:" << endl;

    //Persikeliame geriausius ikiolimpinius rezultatus į tą patį skaičių masyvą, vidurkio skaičiavimui
    for (int i = 0; i <  eiluciuKiekisFaile; i++){
        rezultataiSkaiciavimams[i] = geriausiPasiekimai[i].rezultatas;
    }
    //Paskaičiuojame ir įrašome į failą geriausių ikiolimpinių rezultatų vidurkį
    geriausiuPasiekimuVidurkis = gautiRezultatuVidurki(rezultataiSkaiciavimams, eiluciuKiekisFaile, failasRezultatai);

    failasRezultatai << "Vidurkis ";
    if (geriausiuPasiekimuVidurkis > olimpiniuVidurkis){
        failasRezultatai << geriausiuPasiekimuVidurkis - olimpiniuVidurkis << " m didesnis negu olimpinėse žaidynėse." << endl;
    } else {
        failasRezultatai << olimpiniuVidurkis - geriausiuPasiekimuVidurkis << " m mažesnis negu olimpinėse žaidynėse." << endl;
    }

    failasRezultatai << endl << "Seniausiai pasiektas geriausias rezultatas:" << endl;

    gautiSeniausiaGeriausiaRezultata(geriausiPasiekimai, eiluciuKiekisFaile, failasRezultatai);

    failasRezultatai << endl << "Skirtumas tarp sportininkų pasiekimų:" << endl;

    isrikiuotiPagalSkirtumaNuoOlimpiniu(geriausiPasiekimai, olimpiniuRezultatai, eiluciuKiekisFaile, failasRezultatai);

    failasRezultatai.close();

    return 0;
}
