import csv

class OlimpinisRezultatas:
    def __init__(self, sport_kodas, rezultatas):
        self.sport_kodas = sport_kodas
        self.rezultatas = rezultatas

    def __lt__(self, other):
        return self.rezultatas < other.rezultatas

class GeriausiasPasiekimas:
    def __init__(self, sport_kodas, rezultatas, data, valstybe, skirtumas_olimpiniu):
        self.sport_kodas = sport_kodas
        self.rezultatas = rezultatas
        self.data = data
        self.valstybe = valstybe
        self.skirtumas_olimpiniu = skirtumas_olimpiniu
    
    def __lt__(self, other):
        if GeriausiasPasiekimas.compare_by == 'data':
            return self.data < other.data
        elif GeriausiasPasiekimas.compare_by == 'skirtumas_olimpiniu':
            return self.skirtumas_olimpiniu < other.skirtumas_olimpiniu

# Ši funkcija bus naudojama abiejų rezultatų grupių vidurkių skaičiavimui,
# todėl parametru perduosime skaičių masyvą ir grąžinsime vidurkio reikšmę tolimesniems skaičiavimams
def rasti_vidurki(rezultatai, f_rezultatai):
    rez_vidurkis = 0.0
    rez_vidurkis = sum(i.rezultatas for i in rezultatai) / len(rezultatai)
    f_rezultatai.write(f"Vidutiniškai diskas skriejo {rez_vidurkis:.4f} m.\n")
    return rez_vidurkis

def rasti_max_min_skirtuma(olimp_rezultatai, f_rezultatai):
    min_rezultatas = min(olimp_rezultatai)
    max_rezultatas = max(olimp_rezultatai)
    max_min_skirtumas = max_rezultatas.rezultatas - min_rezultatas.rezultatas
    f_rezultatai.write(f"Skirtumas tarp didžiausio ir mažiausio rezultato {max_min_skirtumas:.2f} m.\n")

def gauti_pavarde(sport_kodas):
    return sport_kodas[1:]

def gauti_metus(data):
    return data // 10000

def rasti_seniausia_rezultata(geriausi_pasiekimai, f_rezultatai):
    GeriausiasPasiekimas.compare_by = 'data'
    seniausi_metai = min(geriausi_pasiekimai)
    f_rezultatai.write(f"{gauti_pavarde(seniausi_metai.sport_kodas)} {seniausi_metai.rezultatas:.4f} "
                       f"{gauti_metus(seniausi_metai.data)} {seniausi_metai.valstybe}\n")

def isrikiuoti_pagal_skirtuma(geriausi_pasiekimai, olimp_rezultatai, f_rezultatai):
    # Suskaičiuojam kiekvieno sportininko skirtumą
    for i in range(len(olimp_rezultatai)):
        geriausi_pasiekimai[i].skirtumas_olimpiniu = geriausi_pasiekimai[i].rezultatas - olimp_rezultatai[i].rezultatas
    
    GeriausiasPasiekimas.compare_by = 'skirtumas_olimpiniu'
    isrusiuoti_pasiekimai = sorted(geriausi_pasiekimai)
   
    # rezultatų įrašymas į failą
    for pasiekimas in isrusiuoti_pasiekimai:
        f_rezultatai.write(f"{gauti_pavarde(pasiekimas.sport_kodas)} {pasiekimas.skirtumas_olimpiniu:.2f} m\n")

# Pagrindinė progama
eiluciu_kiekis = 0
olimpiniu_vid = 0.0
pasiekimu_vid = 0.0
olimp_rezultatai = []
geriausi_pasiekimai = []

# Į klasių objektų masyvą nuskaitome Olimpinių žaidynių rezultatų failą
with open("Olimpines.txt", "r") as f_olimpines:
    eiluciu_kiekis = int(f_olimpines.readline().strip())
    for i in range(eiluciu_kiekis):
        sport_kodas, rezultatas = f_olimpines.readline().strip().split()
        olimp_rezultatai.append(OlimpinisRezultatas(sport_kodas, float(rezultatas)))
        
# Į klasių objektų masyvą nuskaitome geriausių karjeros rezultatų failą
with open("Pasiekimai.csv", "r") as f_pasiekimai:
    reader = csv.reader(f_pasiekimai, delimiter=';')
    for i in range(eiluciu_kiekis):
        row = next(reader)
        sport_kodas, rezultatas, data, valstybe = row
        geriausi_pasiekimai.append(GeriausiasPasiekimas(sport_kodas, float(rezultatas), int(data), valstybe, 0.0))

# Paruošiamas Rezultatų failas
f_rezultatai = open("Rezultatai.txt", "w", encoding = 'utf-8')
f_rezultatai.write("Disko metimo duomenų analizės rezultatai:\n\nOlimpinės žaidynės:\n")

# Paskaičiuojame ir įrašome į failą olimpinių žaidynių rezultatų vidurkį
olimpiniu_vid = rasti_vidurki(olimp_rezultatai, f_rezultatai)
rasti_max_min_skirtuma(olimp_rezultatai, f_rezultatai)

f_rezultatai.write("\nGeriausi rezultatai:\n")

# Paskaičiuojame ir įrašome į failą geriausių ikiolimpinių rezultatų vidurkį
pasiekimu_vid = rasti_vidurki(geriausi_pasiekimai, f_rezultatai)

f_rezultatai.write("Vidurkis ")
if pasiekimu_vid > olimpiniu_vid:
    f_rezultatai.write(f"{(pasiekimu_vid - olimpiniu_vid):.2f} m didesnis negu olimpinėse žaidynėse.\n")
else:
    f_rezultatai.write(f"{(olimpiniu_vid - pasiekimu_vid):.2f} m mažesnis negu olimpinėse žaidynėse.\n")

f_rezultatai.write("\nSeniausiai pasiektas geriausias rezultatas:\n")
rasti_seniausia_rezultata(geriausi_pasiekimai, f_rezultatai)

f_rezultatai.write("\nSkirtumas tarp sportininkų pasiekimų:\n")
isrikiuoti_pagal_skirtuma(geriausi_pasiekimai, olimp_rezultatai, f_rezultatai)

f_rezultatai.close()
