
class OlimpinisRezultatas:
    sport_kodas = ""
    rezultatas = 0.0
    def __init__(self, sport_kodas, rezultatas):
        self.sport_kodas = sport_kodas
        self.rezultatas = rezultatas

class GeriausiasPasiekimas:
    sport_kodas = ""
    rezultatas = 0.0
    data = 0
    valstybe = ""
    skirtumas_olimpiniu = 0.0
    def __init__(self, sport_kodas, rezultatas, data, valstybe, skirtumas_olimpiniu):
        self.sport_kodas = sport_kodas
        self.rezultatas = rezultatas
        self.data = data
        self.valstybe = valstybe
        self.skirtumas_olimpiniu = skirtumas_olimpiniu

# Ši funkcija bus naudojama abiejų rezultatų grupių vidurkių skaičiavimui, 
# todėl parametru perduosime skaičių masyvą ir grąžinsime vidurkio reikšmę tolimesniems skaičiavimams
def rasti_vidurki(rezultatai, f_rezultatai):
    rez_suma = 0.0
    rez_vidurkis = 0.0

    for rez in rezultatai:
        rez_suma += rez.rezultatas

    rez_vidurkis = rez_suma / len(rezultatai)
    f_rezultatai.write(f"Vidutiniškai diskas skriejo {rez_vidurkis:.4f} m.\n")

    return rez_vidurkis

def rasti_max_min_skirtuma(olimp_rezultatai, f_rezultatai):
    min_rezultatas = olimp_rezultatai[0].rezultatas
    max_rezultatas = olimp_rezultatai[0].rezultatas
    max_min_skirtumas = 0.0

    for rez in olimp_rezultatai:
        if rez.rezultatas < min_rezultatas:
            min_rezultatas = rez.rezultatas

        if rez.rezultatas > max_rezultatas:
            max_rezultatas = rez.rezultatas

    max_min_skirtumas = max_rezultatas - min_rezultatas

    f_rezultatai.write(f"Skirtumas tarp didžiausio ir mažiausio rezultato {max_min_skirtumas:.2f} m.\n")

def gauti_pavarde(sport_kodas):
    return sport_kodas[1:]

def gauti_metus(data):
    return data // 10000

def rasti_seniausia_rezultata(geriausi_pasiekimai, f_rezultatai):
    seniausi_metai = gauti_metus(geriausi_pasiekimai[0].data)
    pozicija = 0

    for i in range(len(geriausi_pasiekimai)):
        if gauti_metus(geriausi_pasiekimai[i].data) < seniausi_metai:
            seniausi_metai = gauti_metus(geriausi_pasiekimai[i].data)
            pozicija = i

    f_rezultatai.write(f"{gauti_pavarde(geriausi_pasiekimai[pozicija].sport_kodas)} "
                       f"{geriausi_pasiekimai[pozicija].rezultatas} {gauti_metus(geriausi_pasiekimai[pozicija].data)} "
                       f"{geriausi_pasiekimai[pozicija].valstybe}\n")

def isrikiuoti_pagal_skirtuma(geriausi_pasiekimai, olimp_rezultatai, f_rezultatai):
    isrusiuoti_pasiekimai = []
    laikinas = None  # kintamasis dviejų masyvo reikšmių sukeitimui
    
    # mažėjantis slenkstis kiekvienai iteracijai, iki kurio elemento reikia rūšiuoti burbuliuku
    rik_riba = len(olimp_rezultatai)

    # Suskaičiuojam kiekvieno sportininko skirtumą
    for i in range(len(olimp_rezultatai)):
        geriausi_pasiekimai[i].skirtumas_olimpiniu = geriausi_pasiekimai[i].rezultatas - olimp_rezultatai[i].rezultatas
        isrusiuoti_pasiekimai.append(geriausi_pasiekimai[i])

    # Išrūšiuojam burbuliuko metodu
    for j in range(len(olimp_rezultatai) - 1):
        rik_riba -= 1
        for i in range(rik_riba):
            if isrusiuoti_pasiekimai[i + 1].skirtumas_olimpiniu < isrusiuoti_pasiekimai[i].skirtumas_olimpiniu:
                laikinas = isrusiuoti_pasiekimai[i]
                isrusiuoti_pasiekimai[i] = isrusiuoti_pasiekimai[i + 1]
                isrusiuoti_pasiekimai[i + 1] = laikinas

    # rezultatų įrašymas į failą
    for i in range(len(olimp_rezultatai)):
        f_rezultatai.write(f"{gauti_pavarde(isrusiuoti_pasiekimai[i].sport_kodas)} {isrusiuoti_pasiekimai[i].skirtumas_olimpiniu:.2f} m\n")

# PAGRINDINĖ PROGRAMA
eiluciu_kiekis = 0
olimpiniu_vid = 0.0
pasiekimu_vid = 0.0
olimp_rezultatai = []
geriausi_pasiekimai = []

# Į klasės objektų masyvą nuskaitome Olimpinių žaidynių rezultatų failą
with open("Olimpines.txt", "r") as f_olimpines:
    eiluciu_kiekis = int(f_olimpines.readline().strip())
    for i in range(eiluciu_kiekis):
        eil_irasai = f_olimpines.readline().strip().split()
        olimp_rezultatai.append(OlimpinisRezultatas(eil_irasai[0], float(eil_irasai[1])))
        
# Į klasės objektų masyvą nuskaitome geriausių karjeros rezultatų failą
with open("Pasiekimai.csv", "r") as f_pasiekimai:
    for i in range(eiluciu_kiekis):
        eil_irasai = f_pasiekimai.readline().strip().split(';')
        geriausi_pasiekimai.append(GeriausiasPasiekimas(eil_irasai[0], float(eil_irasai[1]), int(eil_irasai[2]), eil_irasai[3], 0.0))

# Paruošiamas Rezultatų failas
f_rezultatai = open("Rezultatai.txt", "w", encoding = 'utf-8')
f_rezultatai.write("Disko metimo duomenų analizės rezultatai:\n\nOlimpinės žaidynės:\n")

# Paskaičiuojame ir įrašome į failą olimpinių žaidynių rezultatų vidurkį
olimpiniu_vid = rasti_vidurki(olimp_rezultatai, f_rezultatai)
rasti_max_min_skirtuma(olimp_rezultatai, f_rezultatai)

f_rezultatai.write("\nGeriausi rezultatai:\n")

# Paskaičiuojame ir įrašome į failą geriausių iki olimpinių rezultatų vidurkį
pasiekimu_vid = rasti_vidurki(geriausi_pasiekimai, f_rezultatai)

f_rezultatai.write("Vidurkis ")
if pasiekimu_vid > olimpiniu_vid:
    f_rezultatai.write(f"{(pasiekimu_vid - olimpiniu_vid):.4f} m didesnis negu olimpinėse žaidynėse.\n")
else:
    f_rezultatai.write(f"{(olimpiniu_vid - pasiekimu_vid):.4f} m mažesnis negu olimpinėse žaidynėse.\n")

f_rezultatai.write("\nSeniausiai pasiektas geriausias rezultatas:\n")
rasti_seniausia_rezultata(geriausi_pasiekimai, f_rezultatai)

f_rezultatai.write("\nSkirtumas tarp sportininkų pasiekimų:\n")
isrikiuoti_pagal_skirtuma(geriausi_pasiekimai, olimp_rezultatai, f_rezultatai)

f_rezultatai.close()